package ru.yandex.qe.dispenser.domain.dao.quota.spec;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface QuotaSpecDao extends InMemoryKeyDao.Normalized<QuotaSpec, QuotaSpec.Key>, QuotaSpecReader {
    @Override
    default @NotNull QuotaSpec readSingle(@NotNull final Resource resource) {
        final QuotaSpec[] quotaSpecs = filter(qs -> qs.getKey().getResource().equals(resource)).toArray(QuotaSpec[]::new);
        if (quotaSpecs.length == 0) {
            throw new IllegalArgumentException("Resource '" + resource.getKey() + "' has no quota specifications!");
        }
        if (quotaSpecs.length > 1) {
            final String message = String.format("Resource '%s' has %s quota specifications! Please, specify one!", resource.getKey(), quotaSpecs.length);
            throw new IllegalArgumentException(message);
        }
        return quotaSpecs[0];
    }
}
