package ru.yandex.qe.dispenser.domain.dao.quota.spec;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.dao.InMemoryLongKeyDaoImpl;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaDao;

public final class QuotaSpecDaoImpl extends InMemoryLongKeyDaoImpl<QuotaSpec> implements QuotaSpecDao {
    private QuotaDao quotaDao;

    @Override
    public @NotNull QuotaSpec create(final @NotNull QuotaSpec newQuotaSpec) {
        final QuotaSpec quotaSpec = super.create(newQuotaSpec);
        quotaDao.createZeroQuotasFor(quotaSpec);
        return quotaSpec;
    }

    @Override
    public boolean delete(final @NotNull QuotaSpec quotaSpec) {
        if (super.delete(quotaSpec)) {
            quotaDao.deleteAll(quotaDao.getQuotas(quotaSpec));
            return true;
        }
        return false;
    }

    @Autowired
    public void setQuotaDao(@NotNull final QuotaDao quotaDao) {
        this.quotaDao = quotaDao;
    }
}
