package ru.yandex.qe.dispenser.domain.dao.quota.spec;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;

import com.google.common.collect.Multimap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.domain.QuotaSpec;
import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.dao.ReadOnlyDao;
import ru.yandex.qe.dispenser.domain.util.MoreCollectors;

public interface QuotaSpecReader extends ReadOnlyDao.Normalized<QuotaSpec, QuotaSpec.Key> {
    @NotNull
    Set<QuotaSpec> getAll();

    @NotNull
    QuotaSpec readSingle(@NotNull final Resource resource);

    @NotNull
    default Multimap<Resource, QuotaSpec> getByResources(@NotNull final Collection<Resource> resources) {
        return getAll().stream()
                .filter(spec -> resources.contains(spec.getResource()))
                .collect(MoreCollectors.toLinkedMultimap(QuotaSpec::getResource, Function.identity()));
    }

    @NotNull
    default QuotaSpec read(@NotNull final Resource resource, @Nullable final String key) {
        return key == null ? readSingle(resource) : read(new QuotaSpec.Key(key, resource));
    }
}
