package ru.yandex.qe.dispenser.domain.dao.resource;

import java.util.Set;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface ResourceDao extends InMemoryKeyDao.Normalized<Resource, Resource.Key>, ResourceReader {
    @NotNull
    @Override
    default Set<Resource> getByService(@NotNull final Service service) {
        return filter(resource -> resource.getKey().getService().equals(service)).collect(Collectors.toSet());
    }

}
