package ru.yandex.qe.dispenser.domain.dao.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.dao.InMemoryLongKeyDaoImpl;

public final class ResourceDaoImpl extends InMemoryLongKeyDaoImpl<Resource> implements ResourceDao {

    @NotNull
    @Override
    public Map<Long, Resource> tryGetByIds(@NotNull final Set<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        final Map<Long, Resource> result = new HashMap<>();
        ids.forEach(id -> {
            final Resource resource = id2obj.get(id);
            if (resource != null) {
                result.put(id, resource);
            }
        });
        return result;
    }

}
