package ru.yandex.qe.dispenser.domain.dao.resource;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;

import org.jetbrains.annotations.TestOnly;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.ResourceMapping;

public interface ResourceMappingDao {
    @TestOnly
    void create(Collection<ResourceMapping> resourceMappings);

    @TestOnly
    boolean clear();

    Set<ResourceMapping> getAll();

    Set<ResourceMapping> getMappingForResources(Collection<Resource> resources);

    Optional<ResourceMapping> getMappingOptional(long id);

    default Optional<ResourceMapping> getMappingOptional(final Resource resource) {
        return getMappingOptional(resource.getId());
    }
}
