package ru.yandex.qe.dispenser.domain.dao.resource;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.ResourceMapping;
import ru.yandex.qe.dispenser.domain.dao.KeyExtractorInMemoryDaoImpl;
import ru.yandex.qe.dispenser.domain.util.CollectionUtils;

public class ResourceMappingDaoImpl extends KeyExtractorInMemoryDaoImpl<ResourceMapping, Long> implements ResourceMappingDao {

    public ResourceMappingDaoImpl() {
        super(rm -> rm.getResource().getId());
    }

    @Override
    public void create(final Collection<ResourceMapping> resourceMappings) {
        for (final ResourceMapping mapping : resourceMappings) {
            create(mapping);
        }
    }

    @Override
    public Set<ResourceMapping> getMappingForResources(final Collection<Resource> resources) {
        return readAll(CollectionUtils.ids(resources));
    }

    @Override
    public Optional<ResourceMapping> getMappingOptional(final long id) {
        return contains(id) ? Optional.of(read(id)) : Optional.empty();
    }
}
