package ru.yandex.qe.dispenser.domain.dao.resource;

import java.util.Map;
import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.ReadOnlyDao;

public interface ResourceReader extends ReadOnlyDao.Normalized<Resource, Resource.Key> {
    @NotNull
    Set<Resource> getAll();

    @NotNull
    Set<Resource> getByService(@NotNull Service service);

    @NotNull
    Map<Long, Resource> tryGetByIds(@NotNull final Set<Long> ids);

    Set<Resource> readByIds(Set<Long> ids);

}
