package ru.yandex.qe.dispenser.domain.dao.resource.segmentation;


import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.ResourceSegmentation;
import ru.yandex.qe.dispenser.domain.Segmentation;
import ru.yandex.qe.dispenser.domain.dao.GenericDao;

@ParametersAreNonnullByDefault
public interface ResourceSegmentationDao extends ResourceSegmentationReader, GenericDao<ResourceSegmentation, Long> {

    default void setSegmentations(final Resource resource, final Set<Segmentation> segmentationList) {
        clearSegmentations(resource);

        segmentationList
                .forEach(segmentation -> create(new ResourceSegmentation.Builder(resource, segmentation).build()));
    }

    void clearSegmentations(final Resource resource);

    default void createAll(final Collection<ResourceSegmentation> objects) {
        objects.forEach(this::create);
    }
}
