package ru.yandex.qe.dispenser.domain.dao.resource.segmentation;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.ResourceSegmentation;
import ru.yandex.qe.dispenser.domain.dao.InMemoryLongKeyDaoImpl;

public class ResourceSegmentationDaoImpl extends InMemoryLongKeyDaoImpl<ResourceSegmentation> implements ResourceSegmentationDao {
    @Override
    @NotNull
    public Set<ResourceSegmentation> getResourceSegmentations(final @NotNull Resource resource) {
        return getResourceSegmentations(Collections.singleton(resource));
    }

    @Override
    @NotNull
    public Set<ResourceSegmentation> getResourceSegmentations(final @NotNull Collection<Resource> resources) {
        return filter(rs -> resources.contains(rs.getResource()))
                .collect(Collectors.toSet());
    }

    @Override
    public void clearSegmentations(final @NotNull Resource resource) {
        filter(rs -> rs.getResource().equals(resource))
                .forEach(this::delete);
    }
}
