package ru.yandex.qe.dispenser.domain.dao.resource.segmentation;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.ResourceSegmentation;
import ru.yandex.qe.dispenser.domain.Segmentation;

@ParametersAreNonnullByDefault
public interface ResourceSegmentationReader {

    @NotNull
    Set<ResourceSegmentation> getResourceSegmentations(final Resource resource);

    @NotNull
    Set<ResourceSegmentation> getResourceSegmentations(final Collection<Resource> resources);

    @NotNull
    Set<ResourceSegmentation> getAll();

    @NotNull
    default Set<Segmentation> getSegmentations(final Resource resource) {
        return getSegmentations(Collections.singleton(resource));
    }

    @NotNull
    default Set<Segmentation> getSegmentations(final Collection<Resource> resource) {
        return getResourceSegmentations(resource)
                .stream()
                .map(ResourceSegmentation::getSegmentation)
                .collect(Collectors.toSet());
    }

    @NotNull
    default Set<Resource> getResources(final Collection<Segmentation> segmentations) {
        return getAll().stream()
                .filter(qs -> segmentations.contains(qs.getSegmentation()))
                .map(ResourceSegmentation::getResource)
                .collect(Collectors.toSet());
    }

    @NotNull
    default Set<Resource> getResources(final Segmentation segmentation) {
        return getResources(Collections.singleton(segmentation));
    }


}
