package ru.yandex.qe.dispenser.domain.dao.resources_model;

import java.util.List;
import java.util.Set;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.resources_model.ResourcesModelMapping;

public interface ResourcesModelMappingDao {
    List<ResourcesModelMapping> getResourcesMappings(Set<Resource> resources, long campaignId);

    ResourcesModelMapping createResourceMapping(ResourcesModelMapping.Builder mapping);

    List<ResourcesModelMapping> getResourcesMappingsForProvider(Service service, long campaignId);

    List<ResourcesModelMapping> getResourcesMappingsForCampaign(long campaignId);

    List<ResourcesModelMapping> getResourcesMappingsForCampaigns(Set<Long> campaigns);

    void clear();
}
