package ru.yandex.qe.dispenser.domain.dao.resources_model;

import ru.yandex.qe.dispenser.domain.Resource;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.resources_model.ResourcesModelMapping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourcesModelMappingDaoImpl implements ResourcesModelMappingDao {
    private final List<ResourcesModelMapping> mappings = new ArrayList<>();

    @Override
    public synchronized List<ResourcesModelMapping> getResourcesMappings(Set<Resource> resources, long campaignId) {
        return mappings.stream()
                .filter(m -> resources.contains(m.getResource()) && m.getCampaignId() == campaignId)
                .collect(Collectors.toList());
    }

    @Override
    public synchronized List<ResourcesModelMapping> getResourcesMappingsForProvider(Service service, long campaignId) {
        return mappings.stream()
                .filter(m -> m.getResource().getService().equals(service) && m.getCampaignId() == campaignId)
                .collect(Collectors.toList());
    }

    @Override
    public synchronized List<ResourcesModelMapping> getResourcesMappingsForCampaign(long campaignId) {
        return mappings.stream()
                .filter(m -> m.getCampaignId() == campaignId)
                .collect(Collectors.toList());
    }

    @Override
    public synchronized List<ResourcesModelMapping> getResourcesMappingsForCampaigns(Set<Long> campaigns) {
        return mappings.stream()
                .filter(m -> campaigns.contains(m.getCampaignId()))
                .collect(Collectors.toList());
    }

    @Override
    public synchronized ResourcesModelMapping createResourceMapping(ResourcesModelMapping.Builder mapping) {
        long nextId = mappings.stream().max(Comparator.comparing(ResourcesModelMapping::getId))
                .map(ResourcesModelMapping::getId).orElse(-1L) + 1L;
        ResourcesModelMapping result = mapping.build(nextId);
        mappings.add(result);
        return result;
    }

    @Override
    public synchronized void clear() {
        mappings.clear();
    }
}
