package ru.yandex.qe.dispenser.domain.dao.segment;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.EmptyResultDataAccessException;

import ru.yandex.qe.dispenser.domain.Segment;
import ru.yandex.qe.dispenser.domain.Segmentation;
import ru.yandex.qe.dispenser.domain.dao.ReadOnlyDao;

@ParametersAreNonnullByDefault
public interface SegmentReader extends ReadOnlyDao.Normalized<Segment, Segment.Key> {
    @NotNull Set<Segment> getAll();

    @NotNull Set<Segment> get(final Segmentation segmentation);

    @NotNull
    Map<Long, Set<Segment>> getBySegmentationIds(@NotNull final Set<Long> segmentationIds);

    @NotNull Segment read(final String publicKey);

    @Nullable
    default Segment readOrNull(@NotNull final String publicKey) {
        try {
            return read(publicKey);
        } catch (EmptyResultDataAccessException ignored) {
            return null;
        }
    }

    Set<Segment> readByIds(Set<Long> ids);

}
