package ru.yandex.qe.dispenser.domain.dao.service;

import java.util.Collection;
import java.util.Collections;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.InMemoryKeyDao;

public interface ServiceDao extends InMemoryKeyDao.Normalized<Service, String>, ServiceReader {
    default boolean attachAdmin(@NotNull final Service service, @NotNull final Person admin) {
        return attachAdmins(service, Collections.singleton(admin));
    }

    boolean attachAdmins(@NotNull Service service, @NotNull Collection<Person> admins);

    default boolean detachAdmin(@NotNull final Service service, @NotNull final Person admin) {
        return detachAdmins(service, Collections.singleton(admin));
    }

    boolean detachAdmins(@NotNull Service service, @NotNull Collection<Person> admins);

    void detachAllAdmins(@NotNull Service service);

    default boolean attachTrustee(@NotNull final Service service, @NotNull final Person admin) {
        return attachTrustees(service, Collections.singleton(admin));
    }

    boolean attachTrustees(@NotNull Service service, @NotNull Collection<Person> trustees);

    default boolean detachTrustee(@NotNull final Service service, @NotNull final Person trustee) {
        return detachTrustees(service, Collections.singleton(trustee));
    }

    void detachAllTrustees(@NotNull Service service);

    boolean detachTrustees(@NotNull Service service, @NotNull Collection<Person> trustees);
}
