package ru.yandex.qe.dispenser.domain.dao.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import com.google.common.collect.Multimap;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Service;
import ru.yandex.qe.dispenser.domain.dao.ReadOnlyDao;

public interface ServiceReader extends ReadOnlyDao.Normalized<Service, String> {
    @NotNull
    Set<Service> getAll();

    @NotNull
    Set<Service> getAdminServices(@NotNull Person admin);

    @NotNull
    default Set<Person> getAdmins(@NotNull final Service service) {
        return new HashSet<>(getAdmins(Collections.singleton(service)).get(service));
    }

    @NotNull
    Multimap<Service, Person> getAdmins(@NotNull Collection<Service> services);

    @NotNull
    default Set<Person> getTrustees(@NotNull final Service service) {
        return new HashSet<>(getTrustees(Collections.singleton(service)).get(service));
    }

    @NotNull
    Multimap<Service, Person> getTrustees(@NotNull Collection<Service> services);

    Set<Service> readByIds(Set<Long> ids);

}
