package ru.yandex.qe.dispenser.domain.dao.validation;

import java.util.Arrays;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.index.LongIndexable;

@Aspect
public class ValidateAspect {
    @Before("execution(public * *(..)) && @annotation(validate)")
    public void around(@NotNull final JoinPoint jp, @NotNull final Validate validate) throws IllegalArgumentException {
        Arrays.stream(jp.getArgs()).filter(o -> o instanceof LongIndexable).map(o -> (LongIndexable) o).forEach(i -> {
            if (!(i.getId() >= 0 == validate.exists())) {
                throw new IllegalArgumentException("Parameter '" + i.getClass().getSimpleName() + "' (id = [" + i.getId() + " / " + i.toString() + "] must " + (validate.exists() ? "" : "not ") + "exists");
            }
        });
    }
}

