package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiCampaign;

public class CampaignsWithBigOrdersDictionary {

    @NotNull
    private final List<DiCampaign> campaigns;

    @JsonCreator
    public CampaignsWithBigOrdersDictionary(@NotNull @JsonProperty("campaigns") final List<DiCampaign> campaigns) {
        this.campaigns = campaigns;
    }

    @NotNull
    public List<DiCampaign> getCampaigns() {
        return campaigns;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final CampaignsWithBigOrdersDictionary that = (CampaignsWithBigOrdersDictionary) o;
        return campaigns.equals(that.campaigns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(campaigns);
    }

    @Override
    public String toString() {
        return "CampaignsWithBigOrdersDictionary{" +
                "campaigns=" + campaigns +
                '}';
    }

}
