package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProvidersWithCampaignsDictionary {

    @NotNull
    private final List<Provider> providers;

    @JsonCreator
    public ProvidersWithCampaignsDictionary(@NotNull @JsonProperty("providers") final List<Provider> providers) {
        this.providers = providers;
    }

    @NotNull
    public List<Provider> getProviders() {
        return providers;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ProvidersWithCampaignsDictionary that = (ProvidersWithCampaignsDictionary) o;
        return providers.equals(that.providers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providers);
    }

    @Override
    public String toString() {
        return "ProvidersWithCampaignsDictionary{" +
                "providers=" + providers +
                '}';
    }

    public static final class Provider {

        private final long id;
        @NotNull
        private final String key;
        @NotNull
        private final String name;
        @Nullable
        private final Integer priority;
        @NotNull
        private final List<Long> availableInCampaigns;

        @JsonCreator
        public Provider(@JsonProperty("id") final long id,
                        @NotNull @JsonProperty("key") final String key,
                        @NotNull @JsonProperty("name") final String name,
                        @Nullable @JsonProperty("priority") final Integer priority,
                        @NotNull @JsonProperty("availableInCampaigns") final List<Long> availableInCampaigns) {
            this.id = id;
            this.key = key;
            this.name = name;
            this.priority = priority;
            this.availableInCampaigns = availableInCampaigns;
        }

        public long getId() {
            return id;
        }

        @NotNull
        public String getKey() {
            return key;
        }

        @NotNull
        public String getName() {
            return name;
        }

        @Nullable
        @JsonInclude(JsonInclude.Include.NON_NULL)
        public Integer getPriority() {
            return priority;
        }

        @NotNull
        public List<Long> getAvailableInCampaigns() {
            return availableInCampaigns;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Provider provider = (Provider) o;
            return id == provider.id &&
                    key.equals(provider.key) &&
                    name.equals(provider.name) &&
                    Objects.equals(priority, provider.priority) &&
                    availableInCampaigns.equals(provider.availableInCampaigns);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, key, name, priority, availableInCampaigns);
        }

        @Override
        public String toString() {
            return "Provider{" +
                    "id=" + id +
                    ", key='" + key + '\'' +
                    ", name='" + name + '\'' +
                    ", priority=" + priority +
                    ", availableInCampaigns=" + availableInCampaigns +
                    '}';
        }

    }

}
