package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiResourcePreorderReasonType;

public final class RequestReasonsDictionary {

    @NotNull
    private final List<RequestReason> reasons;

    @JsonCreator
    public RequestReasonsDictionary(@NotNull @JsonProperty("reasons") final List<RequestReason> reasons) {
        this.reasons = reasons;
    }

    @NotNull
    public List<RequestReason> getReasons() {
        return reasons;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final RequestReasonsDictionary that = (RequestReasonsDictionary) o;
        return reasons.equals(that.reasons);
    }

    @Override
    public int hashCode() {
        return Objects.hash(reasons);
    }

    @Override
    public String toString() {
        return "RequestReasonsDictionary{" +
                "reasons=" + reasons +
                '}';
    }

    public static final class RequestReason {

        @NotNull
        private final DiResourcePreorderReasonType key;

        @JsonCreator
        public RequestReason(@NotNull @JsonProperty("key") final DiResourcePreorderReasonType key) {
            this.key = key;
        }

        @NotNull
        public DiResourcePreorderReasonType getKey() {
            return key;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final RequestReason that = (RequestReason) o;
            return key == that.key;
        }

        @Override
        public int hashCode() {
            return Objects.hash(key);
        }

        @Override
        public String toString() {
            return "RequestReason{" +
                    "key=" + key +
                    '}';
        }

    }

}
