package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequest;

public final class RequestStatusesDictionary {

    @NotNull
    private final List<RequestStatus> statuses;

    @JsonCreator
    public RequestStatusesDictionary(@NotNull @JsonProperty("statuses") final List<RequestStatus> statuses) {
        this.statuses = statuses;
    }

    @NotNull
    public List<RequestStatus> getStatuses() {
        return statuses;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final RequestStatusesDictionary that = (RequestStatusesDictionary) o;
        return Objects.equals(statuses, that.statuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(statuses);
    }

    @Override
    public String toString() {
        return "RequestStatusesDictionary{" +
                "statuses=" + statuses +
                '}';
    }

    public static final class RequestStatus {

        @NotNull
        private final DiQuotaChangeRequest.Status key;
        @NotNull
        private final DiQuotaChangeRequest.Permission permission;

        @JsonCreator
        public RequestStatus(@NotNull @JsonProperty("key") final DiQuotaChangeRequest.Status key,
                             @NotNull @JsonProperty("permission") final DiQuotaChangeRequest.Permission permission) {
            this.key = key;
            this.permission = permission;
        }

        @NotNull
        public DiQuotaChangeRequest.Status getKey() {
            return key;
        }

        @NotNull
        public DiQuotaChangeRequest.Permission getPermission() {
            return permission;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final RequestStatus that = (RequestStatus) o;
            return key == that.key &&
                    permission == that.permission;
        }

        @Override
        public int hashCode() {
            return Objects.hash(key, permission);
        }

        @Override
        public String toString() {
            return "RequestStatus{" +
                    "key=" + key +
                    ", permission=" + permission +
                    '}';
        }

    }

}
