package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.v1.DiResourceType;

public class ResourcesWithCampaignsDictionary {

    @NotNull
    private final List<Resource> resources;

    @JsonCreator
    public ResourcesWithCampaignsDictionary(@NotNull @JsonProperty("resources") final List<Resource> resources) {
        this.resources = resources;
    }

    @NotNull
    public List<Resource> getResources() {
        return resources;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ResourcesWithCampaignsDictionary that = (ResourcesWithCampaignsDictionary) o;
        return resources.equals(that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resources);
    }

    @Override
    public String toString() {
        return "ResourcesWithCampaignsDictionary{" +
                "resources=" + resources +
                '}';
    }

    public static final class Resource {

        private final long id;
        @NotNull
        private final String key;
        @NotNull
        private final String name;
        @NotNull
        private final DiResourceType type;
        private final long provider;
        @Nullable
        private final Integer priority;
        @NotNull
        private final List<Long> availableInCampaigns;

        @JsonCreator
        public Resource(@JsonProperty("id") final long id,
                        @NotNull @JsonProperty("key") final String key,
                        @NotNull @JsonProperty("name") final String name,
                        @NotNull @JsonProperty("type") final DiResourceType type,
                        @JsonProperty("provider") final long provider,
                        @Nullable @JsonProperty("priority") final Integer priority,
                        @NotNull @JsonProperty("availableInCampaigns") final List<Long> availableInCampaigns) {
            this.id = id;
            this.key = key;
            this.name = name;
            this.type = type;
            this.provider = provider;
            this.priority = priority;
            this.availableInCampaigns = availableInCampaigns;
        }

        public long getId() {
            return id;
        }

        @NotNull
        public String getKey() {
            return key;
        }

        @NotNull
        public String getName() {
            return name;
        }

        @NotNull
        public DiResourceType getType() {
            return type;
        }

        public long getProvider() {
            return provider;
        }

        @Nullable
        public Integer getPriority() {
            return priority;
        }

        @NotNull
        public List<Long> getAvailableInCampaigns() {
            return availableInCampaigns;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Resource resource = (Resource) o;
            return id == resource.id &&
                    provider == resource.provider &&
                    key.equals(resource.key) &&
                    name.equals(resource.name) &&
                    type == resource.type &&
                    Objects.equals(priority, resource.priority) &&
                    availableInCampaigns.equals(resource.availableInCampaigns);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, key, name, type, provider, priority, availableInCampaigns);
        }

        @Override
        public String toString() {
            return "Resource{" +
                    "id=" + id +
                    ", key='" + key + '\'' +
                    ", name='" + name + '\'' +
                    ", type=" + type +
                    ", provider=" + provider +
                    ", priority=" + priority +
                    ", availableInCampaigns=" + availableInCampaigns +
                    '}';
        }

    }

}
