package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.qe.dispenser.domain.ResourceUnit;

@ParametersAreNonnullByDefault
public class ResourcesWithUnitAliasesDictionary {
    private final List<Resource> resources;

    @JsonCreator
    public ResourcesWithUnitAliasesDictionary(@JsonProperty("resources") final List<Resource> resources) {
        this.resources = resources;
    }

    public List<Resource> getResources() {
        return resources;
    }

    public static class Resource {
        private final long id;
        private final String defaultUnit;
        private final ResourceUnit.UnitsSettings units;

        public Resource(@JsonProperty("id") final long id,
                        @JsonProperty("defaultUnit") final String defaultUnit,
                        @JsonProperty("units") final ResourceUnit.UnitsSettings units) {
            this.id = id;
            this.defaultUnit = defaultUnit;
            this.units = units;
        }

        public long getId() {
            return id;
        }

        public String getDefaultUnit() {
            return defaultUnit;
        }

        public ResourceUnit.UnitsSettings getUnits() {
            return units;
        }
    }
}
