package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

public class SegmentationsWithCampaignsDictionary {

    @NotNull
    private final List<Segmentation> segmentations;

    @JsonCreator
    public SegmentationsWithCampaignsDictionary(@JsonProperty("segmentations") @NotNull final List<Segmentation> segmentations) {
        this.segmentations = segmentations;
    }

    @NotNull
    public List<Segmentation> getSegmentations() {
        return segmentations;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final SegmentationsWithCampaignsDictionary that = (SegmentationsWithCampaignsDictionary) o;
        return segmentations.equals(that.segmentations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(segmentations);
    }

    @Override
    public String toString() {
        return "SegmentationsWithCampaignsDictionary{" +
                "segmentations=" + segmentations +
                '}';
    }

    public static final class Segmentation {

        private final long id;
        @NotNull
        private final String key;
        @NotNull
        private final String name;
        @NotNull
        private final List<Segment> segments;
        @NotNull
        private final List<Long> availableInCampaigns;
        private final int priority;

        @JsonCreator
        public Segmentation(@JsonProperty("id") final long id,
                            @NotNull @JsonProperty("key") final String key,
                            @NotNull @JsonProperty("name") final String name,
                            @NotNull @JsonProperty("segments") final List<Segment> segments,
                            @NotNull @JsonProperty("availableInCampaigns") final List<Long> availableInCampaigns,
                            @JsonProperty("priority") final int priority) {
            this.id = id;
            this.key = key;
            this.name = name;
            this.segments = segments;
            this.availableInCampaigns = availableInCampaigns;
            this.priority = priority;
        }

        public long getId() {
            return id;
        }

        @NotNull
        public String getKey() {
            return key;
        }

        @NotNull
        public String getName() {
            return name;
        }

        @NotNull
        public List<Segment> getSegments() {
            return segments;
        }

        @NotNull
        public List<Long> getAvailableInCampaigns() {
            return availableInCampaigns;
        }

        public int getPriority() {
            return priority;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Segmentation that = (Segmentation) o;
            return id == that.id &&
                    priority == that.priority &&
                    key.equals(that.key) &&
                    name.equals(that.name) &&
                    segments.equals(that.segments) &&
                    availableInCampaigns.equals(that.availableInCampaigns);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, key, name, segments, availableInCampaigns, priority);
        }

        @Override
        public String toString() {
            return "Segmentation{" +
                    "id=" + id +
                    ", key='" + key + '\'' +
                    ", name='" + name + '\'' +
                    ", segments=" + segments +
                    ", availableInCampaigns=" + availableInCampaigns +
                    ", priority=" + priority +
                    '}';
        }
    }

    public static final class Segment {
        private final long id;
        @NotNull
        private final String key;
        @NotNull
        private final String name;
        private final short priority;

        @JsonCreator
        public Segment(@JsonProperty("id") final long id,
                       @NotNull @JsonProperty("key") final String key,
                       @NotNull @JsonProperty("name") final String name,
                       @JsonProperty("priority") final short priority) {
            this.id = id;
            this.key = key;
            this.name = name;
            this.priority = priority;
        }

        public long getId() {
            return id;
        }

        @NotNull
        public String getKey() {
            return key;
        }

        @NotNull
        public String getName() {
            return name;
        }

        public short getPriority() {
            return priority;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final Segment segment = (Segment) o;
            return id == segment.id &&
                    priority == segment.priority &&
                    key.equals(segment.key) &&
                    name.equals(segment.name);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, key, name, priority);
        }

        @Override
        public String toString() {
            return "Segment{" +
                    "id=" + id +
                    ", key='" + key + '\'' +
                    ", name='" + name + '\'' +
                    ", priority=" + priority +
                    '}';
        }

    }
}
