package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.api.v1.DiQuotaChangeRequestSortField;

public final class SortFieldsDictionary {

    @NotNull
    private final List<SortField> sortFields;

    @JsonCreator
    public SortFieldsDictionary(@NotNull @JsonProperty("sortFields") final List<SortField> sortFields) {
        this.sortFields = sortFields;
    }

    public List<SortField> getSortFields() {
        return sortFields;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final SortFieldsDictionary that = (SortFieldsDictionary) o;
        return sortFields.equals(that.sortFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sortFields);
    }

    @Override
    public String toString() {
        return "SortFieldsDictionary{" +
                "sortFields=" + sortFields +
                '}';
    }

    public static final class SortField {

        @NotNull
        private final DiQuotaChangeRequestSortField key;

        @JsonCreator
        public SortField(@NotNull @JsonProperty("key") final DiQuotaChangeRequestSortField key) {
            this.key = key;
        }

        @NotNull
        public DiQuotaChangeRequestSortField getKey() {
            return key;
        }

        @Override
        public boolean equals(final Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            final SortField sortField = (SortField) o;
            return key == sortField.key;
        }

        @Override
        public int hashCode() {
            return Objects.hash(key);
        }

        @Override
        public String toString() {
            return "SortField{" +
                    "key=" + key +
                    '}';
        }

    }

}
