package ru.yandex.qe.dispenser.domain.dictionaries.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class UnitsDictionary {

    private final List<Ensemble> ensembles;
    private final List<Unit> units;
    private final List<ResourceType> resourceTypes;

    @JsonCreator
    public UnitsDictionary(@JsonProperty("ensembles") final List<Ensemble> ensembles,
                           @JsonProperty("units") final List<Unit> units,
                           @JsonProperty("resourceTypes") final List<ResourceType> resourceTypes) {
        this.ensembles = ensembles;
        this.units = units;
        this.resourceTypes = resourceTypes;
    }


    public List<Ensemble> getEnsembles() {
        return ensembles;
    }

    public List<Unit> getUnits() {
        return units;
    }

    public List<ResourceType> getResourceTypes() {
        return resourceTypes;
    }

    public static class Ensemble {
        private final String key;
        private final long base;

        @JsonCreator
        public Ensemble(@JsonProperty("key") final String key,
                        @JsonProperty("base") final long base) {
            this.key = key;
            this.base = base;
        }

        public String getKey() {
            return key;
        }

        public long getBase() {
            return base;
        }
    }

    public static class Unit {
        private final String key;
        private final String name;
        private final String ensemble;
        private final UnitMultiplier multiplier;

        @JsonCreator
        public Unit(@JsonProperty("key") final String key,
                    @JsonProperty("name") final String name,
                    @JsonProperty("ensemble") final String ensemble,
                    @JsonProperty("multiplier") final UnitMultiplier multiplier) {
            this.key = key;
            this.name = name;
            this.ensemble = ensemble;
            this.multiplier = multiplier;
        }

        public String getKey() {
            return key;
        }

        public String getName() {
            return name;
        }

        public String getEnsemble() {
            return ensemble;
        }

        public UnitMultiplier getMultiplier() {
            return multiplier;
        }
    }

    public static class UnitMultiplier {
        private final int power;

        @JsonCreator
        public UnitMultiplier(@JsonProperty("power") final int power) {
            this.power = power;
        }

        public int getPower() {
            return power;
        }
    }

    public static class ResourceType {
        private final String key;
        private final String baseUnit;

        @JsonCreator
        public ResourceType(@JsonProperty("key") final String key,
                            @JsonProperty("baseUnit") final String baseUnit) {
            this.key = key;
            this.baseUnit = baseUnit;
        }

        public String getKey() {
            return key;
        }

        public String getBaseUnit() {
            return baseUnit;
        }
    }
}
