package ru.yandex.qe.dispenser.domain.exception;

import javax.ws.rs.core.Response;

public enum  ExceptionType {
    UNKNOWN(Response.Status.INTERNAL_SERVER_ERROR, "Unknown error"),
    NOT_FOUND(Response.Status.NOT_FOUND, "Not found"),
    ILLEGAL_ARGUMENT(Response.Status.BAD_REQUEST, "Invalid argument"),
    FORBIDDEN(Response.Status.FORBIDDEN, "Forbidden"),
    ;

    private final Response.Status status;
    private final String title;

    ExceptionType(final Response.Status status, final String title) {
        this.status = status;
        this.title = title;
    }

    public Response.Status getStatus() {
        return status;
    }

    public String getTitle() {
        return title;
    }
}
