package ru.yandex.qe.dispenser.domain.exception;

import ru.yandex.qe.dispenser.domain.i18n.LocalizableString;
import ru.yandex.qe.dispenser.domain.util.Errors;

public class MultiMessageException extends LocalizableException {
    private final Errors<LocalizableString> errors;

    public MultiMessageException(final ExceptionType type, final Errors<LocalizableString> errors) {
        super(type);
        this.errors = errors;
    }

    public MultiMessageException(final Throwable cause, final ExceptionType type, final Errors<LocalizableString> errors) {
        super(cause, type);
        this.errors = errors;
    }

    public Errors<LocalizableString> getErrors() {
        return errors;
    }

    public static MultiMessageException illegalArgument(final Errors<LocalizableString> errors) {
        return new MultiMessageException(ExceptionType.ILLEGAL_ARGUMENT, errors);
    }

    public static MultiMessageException forbidden(final Errors<LocalizableString> errors) {
        return new MultiMessageException(ExceptionType.FORBIDDEN, errors);
    }

    public static MultiMessageException unknown(final Errors<LocalizableString> errors) {
        return new MultiMessageException(ExceptionType.UNKNOWN, errors);
    }
}
