package ru.yandex.qe.dispenser.domain.exception;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.i18n.LocalizableString;

public class SingleMessageException extends LocalizableException {
    private final LocalizableString localizableString;

    public SingleMessageException(final ExceptionType type, final LocalizableString localizableString) {
        super(type);
        this.localizableString = localizableString;
    }

    public SingleMessageException(final Throwable cause, final ExceptionType type, final LocalizableString localizableString) {
        super(cause, type);
        this.localizableString = localizableString;
    }

    public LocalizableString getLocalizableString() {
        return localizableString;
    }

    @NotNull
    public static SingleMessageException illegalArgument(@NotNull final LocalizableString string) {
        return new SingleMessageException(ExceptionType.ILLEGAL_ARGUMENT, string);
    }

    @NotNull
    public static SingleMessageException illegalArgument(@NotNull final String key, @NotNull final Object... args) {
        return new SingleMessageException(ExceptionType.ILLEGAL_ARGUMENT, LocalizableString.of(key, args));
    }

    @NotNull
    public static SingleMessageException forbidden(@NotNull final LocalizableString string) {
        return new SingleMessageException(ExceptionType.FORBIDDEN, string);
    }

    @NotNull
    public static SingleMessageException forbidden(@NotNull final String key, @NotNull final Object... args) {
        return new SingleMessageException(ExceptionType.FORBIDDEN, LocalizableString.of(key, args));
    }

    @NotNull
    public static SingleMessageException illegalArgument(@NotNull final Throwable cause, @NotNull final String key, @NotNull final Object... args) {
        return new SingleMessageException(cause, ExceptionType.ILLEGAL_ARGUMENT, LocalizableString.of(key, args));
    }

    public static SingleMessageException unknown(@NotNull final String key, @NotNull final Object... args) {
        return new SingleMessageException(ExceptionType.UNKNOWN, LocalizableString.of(key, args));
    }

    public static SingleMessageException notFound(@NotNull final String key, @NotNull final Object... args) {
        return new SingleMessageException(ExceptionType.NOT_FOUND, LocalizableString.of(key, args));
    }

    public static SingleMessageException unknown(@NotNull final Throwable cause, @NotNull final String key, @NotNull final Object... args) {
        return new SingleMessageException(cause, ExceptionType.UNKNOWN, LocalizableString.of(key, args));
    }
}
