package ru.yandex.qe.dispenser.domain.health;

import java.util.Objects;
import java.util.Optional;

@FunctionalInterface
public interface HealthCheck {

    Result check();

    final class Result {

        private final boolean healthy;
        private final String message;

        public Result(boolean healthy, String message) {
            this.healthy = healthy;
            this.message = message;
        }

        public static Result healthy() {
            return new Result(true, null);
        }

        public static Result unhealthy(String message) {
            return new Result(false, message);
        }

        public boolean isHealthy() {
            return healthy;
        }

        public Optional<String> getMessage() {
            return Optional.ofNullable(message);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result) o;
            return healthy == result.healthy &&
                    Objects.equals(message, result.message);
        }

        @Override
        public int hashCode() {
            return Objects.hash(healthy, message);
        }

        @Override
        public String toString() {
            return "Result{" +
                    "healthy=" + healthy +
                    ", message='" + message + '\'' +
                    '}';
        }

    }

}
