package ru.yandex.qe.dispenser.domain.health;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HealthChecks {

    private static final Logger LOG = LoggerFactory.getLogger(HealthChecks.class);

    private final ConcurrentMap<String, HealthCheck> healthChecks = new ConcurrentHashMap<>();

    public void register(String name, HealthCheck healthCheck) {
        healthChecks.put(name, healthCheck);
    }

    public void unregister(String name) {
        healthChecks.remove(name);
    }

    public Map<String, HealthCheck.Result> runHealthChecks() {
        Map<String, HealthCheck.Result> results = new HashMap<>();
        healthChecks.forEach((key, value) -> results.put(key, execute(value)));
        return Collections.unmodifiableMap(results);
    }

    private HealthCheck.Result execute(HealthCheck check) {
        try {
            return check.check();
        } catch (Exception e) {
            LOG.error("Failed health check", e);
            return HealthCheck.Result.unhealthy("Failed health check: " + e);
        }
    }

}
