package ru.yandex.qe.dispenser.domain.hierarchy;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.dao.dispenser_admins.DispenserAdminsReader;
import ru.yandex.qe.dispenser.domain.dao.entity.meta.EntityMetaTypeReader;
import ru.yandex.qe.dispenser.domain.dao.entity.spec.EntitySpecReader;
import ru.yandex.qe.dispenser.domain.dao.person.PersonReader;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectReader;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectUtils;
import ru.yandex.qe.dispenser.domain.dao.property.PropertyReader;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaCache;
import ru.yandex.qe.dispenser.domain.dao.quota.spec.QuotaSpecReader;
import ru.yandex.qe.dispenser.domain.dao.resource.ResourceReader;
import ru.yandex.qe.dispenser.domain.dao.resource.group.ResourceGroupReader;
import ru.yandex.qe.dispenser.domain.dao.resource.segmentation.ResourceSegmentationReader;
import ru.yandex.qe.dispenser.domain.dao.segment.SegmentReader;
import ru.yandex.qe.dispenser.domain.dao.segmentation.SegmentationReader;
import ru.yandex.qe.dispenser.domain.dao.service.ServiceReader;

@Immutable
public interface Hierarchy {
    @NotNull
    default Set<Project> getResponsilbeRealLeafProjects(@NotNull final Person responsible) {
        return ProjectUtils.filterRealLeafs(getResponsibleProjects(responsible));
    }

    @NotNull
    default Set<Project> getMemberRealLeafProjects(@NotNull final Person member) {
        return ProjectUtils.filterRealLeafs(getMemberProjects(member));
    }

    @NotNull
    default Set<Project> getResponsibleProjects(@NotNull final Person responsible) {
        if (isDispenserAdmin(responsible)) {
            return getProjectReader().getAll();
        }
        return getRealResponsibleProjects(responsible);
    }

    @NotNull
    default Set<Project> getMemberProjects(@NotNull final Person member) {
        final Set<Project> resultNodes = new HashSet<>();
        resultNodes.addAll(getPersonReader().getLinkedProjects(member, Role.MEMBER));
        resultNodes.addAll(getRealResponsibleProjects(member));
        return ProjectUtils.subTree(resultNodes);
    }

    @NotNull
    default Set<Project> getRealResponsibleProjects(@NotNull final Person responsible) {
        return ProjectUtils.subTree(getPersonReader().getLinkedProjects(responsible, Role.RESPONSIBLE));
    }

    default boolean isDispenserAdmin(@NotNull final Person person) {
        return getDispenserAdminsReader().getDispenserAdmins().contains(person);
    }

    @NotNull
    DispenserAdminsReader getDispenserAdminsReader();

    @NotNull
    PersonReader getPersonReader();

    @NotNull
    ProjectReader getProjectReader();

    @NotNull
    ServiceReader getServiceReader();

    @NotNull
    ResourceReader getResourceReader();

    @NotNull
    QuotaSpecReader getQuotaSpecReader();

    @NotNull
    QuotaCache getQuotaCache();

    @NotNull
    EntitySpecReader getEntitySpecReader();

    @NotNull
    EntityMetaTypeReader getEntityMetaTypeReader();

    @NotNull
    SegmentationReader getSegmentationReader();

    @NotNull
    SegmentReader getSegmentReader();

    @NotNull
    ResourceSegmentationReader getResourceSegmentationReader();

    @NotNull
    ResourceGroupReader getResourceGroupReader();

    @NotNull
    PropertyReader getPropertyReader();

    @NotNull
    PermissionsCache getPermissionsCache();

    @NotNull
    static Hierarchy get() {
        return Objects.requireNonNull(Session.HIERARCHY.get(), "No hierarchy in session!");
    }

    boolean isSql();
}
