package ru.yandex.qe.dispenser.domain.hierarchy;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.Project;
import ru.yandex.qe.dispenser.domain.dao.dispenser_admins.DispenserAdminsReader;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectReader;
import ru.yandex.qe.dispenser.domain.dao.service.ServiceReader;

public interface PermissionsCache {

    boolean canUserViewMoney(Person person);

    boolean canUserViewBotMoney(Person person);

    void invalidateCaches();

    static boolean isMember(ProjectReader projectReader, Person person, Project project) {
        return projectReader.hasRole(person, project, Role.MEMBER);
    }

    static boolean isResponsible(ProjectReader projectReader, Person person, Project project) {
        return projectReader.hasRole(person, project, Role.RESPONSIBLE);
    }

    static boolean isUserProcessResponsibleOrProvidersAdmin(ProjectReader projectReader, ServiceReader serviceReader,
                                                            Person person) {
        return isUserProcessResponsible(projectReader, person) || isProvidersAdmin(serviceReader, person);
    }

    static boolean isUserProcessResponsible(ProjectReader projectReader, Person person) {
        return projectReader.hasRole(person, projectReader.getRoot(), Role.PROCESS_RESPONSIBLE);
    }

    static boolean isProvidersAdmin(ServiceReader serviceReader, Person person) {
        return !serviceReader.getAdminServices(person).isEmpty();
    }

    static boolean isDispenserAdmin(DispenserAdminsReader dispenserAdminsReader, Person person) {
        return dispenserAdminsReader.getDispenserAdmins().contains(person);
    }

    static boolean isResourceOrderManager(ProjectReader projectReader, Person person, Project project) {
        return projectReader.hasRole(person, project, Role.RESOURCE_ORDER_MANAGER);
    }

}
