package ru.yandex.qe.dispenser.domain.hierarchy;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.domain.dao.dispenser_admins.DispenserAdminsDao;
import ru.yandex.qe.dispenser.domain.dao.dispenser_admins.DispenserAdminsReader;
import ru.yandex.qe.dispenser.domain.dao.entity.meta.EntityMetaTypeDaoImpl;
import ru.yandex.qe.dispenser.domain.dao.entity.meta.EntityMetaTypeReader;
import ru.yandex.qe.dispenser.domain.dao.entity.spec.EntitySpecDao;
import ru.yandex.qe.dispenser.domain.dao.entity.spec.EntitySpecReader;
import ru.yandex.qe.dispenser.domain.dao.person.PersonReader;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectDao;
import ru.yandex.qe.dispenser.domain.dao.project.ProjectReader;
import ru.yandex.qe.dispenser.domain.dao.project.SqlProjectDao;
import ru.yandex.qe.dispenser.domain.dao.property.CachingPropertyReader;
import ru.yandex.qe.dispenser.domain.dao.property.PropertyDao;
import ru.yandex.qe.dispenser.domain.dao.property.PropertyDaoImpl;
import ru.yandex.qe.dispenser.domain.dao.property.PropertyReader;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaCache;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaCacheImpl;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaDao;
import ru.yandex.qe.dispenser.domain.dao.quota.QuotaDaoImpl;
import ru.yandex.qe.dispenser.domain.dao.quota.spec.QuotaSpecDao;
import ru.yandex.qe.dispenser.domain.dao.quota.spec.QuotaSpecReader;
import ru.yandex.qe.dispenser.domain.dao.resource.ResourceDao;
import ru.yandex.qe.dispenser.domain.dao.resource.ResourceReader;
import ru.yandex.qe.dispenser.domain.dao.resource.group.ResourceGroupDao;
import ru.yandex.qe.dispenser.domain.dao.resource.group.ResourceGroupReader;
import ru.yandex.qe.dispenser.domain.dao.resource.segmentation.ResourceSegmentationDao;
import ru.yandex.qe.dispenser.domain.dao.resource.segmentation.ResourceSegmentationReader;
import ru.yandex.qe.dispenser.domain.dao.segment.SegmentDao;
import ru.yandex.qe.dispenser.domain.dao.segment.SegmentReader;
import ru.yandex.qe.dispenser.domain.dao.segmentation.SegmentationDao;
import ru.yandex.qe.dispenser.domain.dao.segmentation.SegmentationReader;
import ru.yandex.qe.dispenser.domain.dao.service.ServiceDao;
import ru.yandex.qe.dispenser.domain.dao.service.ServiceReader;

@Component
public final class ProxyingHierarchy implements Hierarchy {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyingHierarchy.class);

    @Autowired
    private PersonReader personReader;

    private PropertyReader propertyReader;
    private QuotaCache quotaCache;

    @Autowired
    private DispenserAdminsDao dispenserAdminsDao;
    @Autowired
    private ProjectDao projectDao;
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    private QuotaSpecDao quotaSpecDao;
    @Autowired
    private QuotaDao quotaDao;
    @Autowired
    private EntitySpecDao entitySpecDao;
    @Autowired
    private SegmentationDao segmentationDao;
    @Autowired
    private SegmentDao segmentDao;
    @Autowired
    private ResourceSegmentationDao resourceSegmentationDao;
    @Autowired
    private ResourceGroupDao resourceGroupDao;
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    @Lazy
    private PermissionsCache permissionsCache;

    @NotNull
    @Override
    public DispenserAdminsReader getDispenserAdminsReader() {
        return dispenserAdminsDao;
    }

    @NotNull
    @Override
    public PersonReader getPersonReader() {
        return personReader;
    }

    @NotNull
    @Override
    public ProjectReader getProjectReader() {
        return projectDao;
    }

    @NotNull
    @Override
    public ServiceReader getServiceReader() {
        return serviceDao;
    }

    @NotNull
    @Override
    public ResourceReader getResourceReader() {
        return resourceDao;
    }

    @NotNull
    @Override
    public QuotaSpecReader getQuotaSpecReader() {
        return quotaSpecDao;
    }

    @NotNull
    @Override
    public QuotaCache getQuotaCache() {
        if (quotaCache == null) {
            if (quotaDao instanceof QuotaDaoImpl) {
                return new QuotaCacheImpl(quotaDao.getAll());
            }
            throw new IllegalArgumentException("Quota cache not initialized");
        }
        return quotaCache;
    }

    @NotNull
    @Override
    public EntitySpecReader getEntitySpecReader() {
        return entitySpecDao;
    }

    @NotNull
    @Override
    public EntityMetaTypeReader getEntityMetaTypeReader() {
        return EntityMetaTypeDaoImpl.EMTPY;
    }

    @NotNull
    @Override
    public SegmentationReader getSegmentationReader() {
        return segmentationDao;
    }

    @NotNull
    @Override
    public SegmentReader getSegmentReader() {
        return segmentDao;
    }

    @NotNull
    @Override
    public ResourceSegmentationReader getResourceSegmentationReader() {
        return resourceSegmentationDao;
    }

    @NotNull
    @Override
    public ResourceGroupReader getResourceGroupReader() {
        return resourceGroupDao;
    }

    @NotNull
    @Override
    public PropertyReader getPropertyReader() {
        if (propertyReader == null) {
            if (propertyDao instanceof PropertyDaoImpl) {
                propertyReader = (PropertyDaoImpl) propertyDao;
            } else {
                propertyReader = new CachingPropertyReader(propertyDao);
            }
        }
        return propertyReader;
    }

    @NotNull
    @Override
    public PermissionsCache getPermissionsCache() {
        return permissionsCache;
    }

    @Override
    public boolean isSql() {
        //TODO check this code
        return projectDao instanceof SqlProjectDao;
    }

    public void setPersonReader(@NotNull final PersonReader personReader) {
        this.personReader = personReader;
    }

    public void setProjectDao(@NotNull final ProjectDao projectDao) {
        this.projectDao = projectDao;
    }

    public void setServiceDao(@NotNull final ServiceDao serviceDao) {
        this.serviceDao = serviceDao;
    }

    public void setDispenserAdminsDao(@NotNull final DispenserAdminsDao dispenserAdminsDao) {
        this.dispenserAdminsDao = dispenserAdminsDao;
    }

    public void setResourceDao(@NotNull final ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    public void setQuotaSpecDao(@NotNull final QuotaSpecDao quotaSpecDao) {
        this.quotaSpecDao = quotaSpecDao;
    }

    public void setQuotaCache(@NotNull final QuotaCache quotaCache) {
        this.quotaCache = quotaCache;
    }

    public void setEntitySpecDao(@NotNull final EntitySpecDao entitySpecDao) {
        this.entitySpecDao = entitySpecDao;
    }

    public void setSegmentationDao(@NotNull final SegmentationDao segmentationDao) {
        this.segmentationDao = segmentationDao;
    }

    public void setSegmentDao(@NotNull final SegmentDao segmentDao) {
        this.segmentDao = segmentDao;
    }

    public void setResourceSegmentationDao(@NotNull final ResourceSegmentationDao dao) {
        this.resourceSegmentationDao = dao;
    }

    public void setResourceGroupDao(@NotNull final ResourceGroupDao dao) {
        this.resourceGroupDao = dao;
    }

    public void setPropertyReader(@NotNull final PropertyReader propertyReader) {
        this.propertyReader = propertyReader;
    }

    public void setPermissionsCache(@NotNull final PermissionsCache permissionsCache) {
        this.permissionsCache = permissionsCache;
    }
}
