package ru.yandex.qe.dispenser.domain.hierarchy;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.Nullable;

public enum Role {
    MEMBER("MEMBER"),
    RESPONSIBLE("RESPONSIBLE"),
    QUOTA_MANAGER("QUOTA_MANAGER"),
    STEWARD("STEWARD"),
    PROCESS_RESPONSIBLE("PROCESS_RESPONSIBLE"),
    VS_LEADER("VS_LEADER"),
    RESOURCE_ORDER_MANAGER("RESOURCE_ORDER_MANAGER"),
    ;


    private static final ImmutableMap<String, Role> ROLE_BY_KEY;

    static {
        ROLE_BY_KEY = ImmutableMap.copyOf(Arrays.stream(values())
                .collect(Collectors.toMap(Role::getKey, Function.identity())));
    }

    private final String key;


    Role(final String key) {
        this.key = key;
    }

    @Nullable
    public static Role byKey(final String roleKey) {
        return ROLE_BY_KEY.get(roleKey);
    }

    public String getKey() {
        return key;
    }
}
