package ru.yandex.qe.dispenser.domain.hierarchy;

import java.util.Locale;

import ru.yandex.qe.dispenser.domain.Person;
import ru.yandex.qe.dispenser.domain.util.ApplicationContextProvider;

public enum Session {
    ;

    public static final ThreadLocal<Hierarchy> HIERARCHY = ThreadLocal.withInitial(() -> ApplicationContextProvider.getContext().getBean(ProxyingHierarchy.class));

    public static final ThreadLocal<Throwable> ERROR = new ThreadLocal<>();

    public static final ThreadLocal<String> AUTH_LOGIN = new ThreadLocal<>();

    public static final ThreadLocal<Person> WHOAMI = new ThreadLocal<>();

    public static final ThreadLocal<String> REQID = new ThreadLocal<>();

    public static final ThreadLocal<Boolean> TRY_ACQUIRE = ThreadLocal.withInitial(() -> false);

    public static final ThreadLocal<Boolean> IS_READONLY = ThreadLocal.withInitial(() -> false);

    public static final ThreadLocal<Locale> USER_LOCALE = ThreadLocal.withInitial(() -> Locale.ENGLISH);

}
