package ru.yandex.qe.dispenser.domain.history;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.domain.dao.history.HistoryDao;

public abstract class HistoryClearTask {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryClearTask.class);

    protected final HistoryDao historyDao;
    protected final Duration duration;
    protected final boolean enabled;

    protected HistoryClearTask(final HistoryDao historyDao, final Duration duration, final boolean enabled) {
        this.historyDao = historyDao;
        this.duration = duration;
        this.enabled = enabled;
    }

    public void clear() {
        if (!enabled) {
            return;
        }
        LOG.info("Task '" + getName() + "' is starting to clear history");
        final Instant moment = Instant.now().minus(duration);
        final Stopwatch stopwatch = Stopwatch.createStarted();

        historyDao.clearBefore(moment);

        final long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        LOG.info("Task '" + getName() + "' finished in " + elapsed + " ms");
    }

    public String getName() {
        return getClass().getSimpleName();
    }
}
