package ru.yandex.qe.dispenser.domain.history;

import java.time.Duration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.domain.dao.history.request.QuotaChangeRequestHistoryDao;

@Component
@Profile("secondary")
public class QuotaChangeRequestHistoryClearTask extends HistoryClearTask {

    public QuotaChangeRequestHistoryClearTask(final QuotaChangeRequestHistoryDao historyDao,
                                              @Value("${quota.request.history.duration.millis}") final long durationInMillis,
                                              @Value("${quota.request.history.clearTask.enabled}") final boolean enabled) {
        super(historyDao, Duration.ofMillis(durationInMillis), enabled);
    }
}
