package ru.yandex.qe.dispenser.domain.history;

import java.time.Duration;

import javax.inject.Inject;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.domain.dao.history.quota.QuotaHistoryDao;

@Component
@Profile("secondary")
public class QuotaHistoryClearTask extends HistoryClearTask {

    @Inject
    public QuotaHistoryClearTask(final QuotaHistoryDao historyDao,
                                 @Value("${quota.history.duration.millis}") final long durationInMillis,
                                 @Value("${quota.history.clearTask.enabled}") final boolean enabled) {
        super(historyDao, Duration.ofMillis(durationInMillis), enabled);
    }
}
