package ru.yandex.qe.dispenser.domain.i18n;

import java.util.Locale;
import java.util.Optional;

import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;

public class LocalizableString {
    private final String key;
    private final Object[] args;

    public LocalizableString(final String key, final Object... args) {
        this.key = key;
        this.args = args;
    }

    public String getKey() {
        return key;
    }

    public Object[] getArgs() {
        return args;
    }

    public static LocalizableString of(final String key, final Object... args) {
        return new LocalizableString(key, args);
    }

    public Optional<String> resolve(final MessageSource messageSource, final Locale locale) {
        try {
            return Optional.of(messageSource.getMessage(key, args, locale));
        } catch (NoSuchMessageException e) {
            return Optional.empty();
        }
    }
}
