package ru.yandex.qe.dispenser.domain.index;

import org.jetbrains.annotations.NotNull;

public final class LongIndex<T> extends SupplierImpl<T> implements LongIndexable {
    private final long id;

    private LongIndex(final long id, @NotNull final T obj) {
        super(obj);
        this.id = id;
    }

    @NotNull
    public static <T> LongIndex<T> of(final long id, @NotNull final T obj) {
        return new LongIndex<>(id, obj);
    }

    @Override
    public long getId() {
        return id;
    }
}
