package ru.yandex.qe.dispenser.domain.index;

import org.jetbrains.annotations.NotNull;

public abstract class LongIndexBase implements LongIndexable, IndexConsumer<Long> {
    private volatile long id = -1;

    @Override
    public final long getId() {
        return id;
    }

    @Override
    public final void setId(@NotNull final Long id) {
        if (id < 0) {
            throw new IllegalStateException("'" + getClass().getSimpleName() + "' id = [" + id + "] is below zero!");
        }
        this.id = id;
    }
}
