package ru.yandex.qe.dispenser.domain.index;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import ru.yandex.qe.dispenser.api.Keyable;

public abstract class NormalizedPrimaryKeyBase<T extends Comparable<T>> extends LongIndexBase implements Keyable<T> {
    @NotNull
    private final T key;

    protected NormalizedPrimaryKeyBase(@NotNull final T key) {
        this.key = key;
    }

    @NotNull
    @Override
    public final T getKey() {
        return key;
    }

    @Override
    public final boolean equals(@Nullable final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final NormalizedPrimaryKeyBase<?> that = (NormalizedPrimaryKeyBase<?>) o;
        return getKey().equals(that.getKey());
    }

    @Override
    public final int hashCode() {
        return getKey().hashCode();
    }

    @Override
    public String toString() {
        return getKey().toString();
    }
}
