package ru.yandex.qe.dispenser.domain.jns

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonProperty

/**
 * Jns message.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class JnsRequest(
    @JsonProperty("project") val project: String,
    @JsonProperty("template") val template: String,
    @JsonProperty("target_project") val targetProject: String,
    @JsonProperty("channel") val channel: String,
    @JsonProperty("request_id") val requestId: String,
    @JsonProperty("params") val params: Map<String, String>
)
