package ru.yandex.qe.dispenser.domain.juggler;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class ActiveCheckKwargs {
    @NotNull
    private final String path;
    @NotNull
    private final Collection<Integer> okCodes;
    @NotNull
    private final Collection<Integer> warnCodes;

    private final boolean alwaysShowBody;

    @JsonCreator
    public ActiveCheckKwargs(@JsonProperty("path") final String path,
                             @JsonProperty("ok_codes") final Collection<Integer> okCodes,
                             @JsonProperty("warn_codes") final Collection<Integer> warnCodes,
                             @JsonProperty("always_show_body") final boolean alwaysShowBody) {
        this.path = path;
        this.okCodes = okCodes;
        this.warnCodes = warnCodes;
        this.alwaysShowBody = alwaysShowBody;
    }

    @NotNull
    public String getPath() {
        return path;
    }

    @NotNull
    @JsonProperty("ok_codes")
    public Collection<Integer> getOkCodes() {
        return okCodes;
    }

    @NotNull
    @JsonProperty("warn_codes")
    public Collection<Integer> getWarnCodes() {
        return warnCodes;
    }

    @JsonProperty("always_show_body")
    public boolean isAlwaysShowBody() {
        return alwaysShowBody;
    }
}
