package ru.yandex.qe.dispenser.domain.juggler;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public enum ActiveCheckType {
    HTTPS("https");

    @NotNull
    private final String type;

    @NotNull
    @JsonCreator
    private static ActiveCheckType fromJson(final String json) {
        for (final ActiveCheckType value : values()) {
            if (value.type.equals(json)) {
                return value;
            }
        }
        throw new IllegalArgumentException("invalid check type");
    }

    ActiveCheckType(final String type) {
        this.type = type;
    }

    @JsonValue
    @NotNull
    public String getType() {
        return type;
    }
}
