package ru.yandex.qe.dispenser.domain.juggler;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class AddCheckResult {

    private final boolean success;
    @NotNull
    private final String message;

    public AddCheckResult(@JsonProperty("success") final boolean success,
                          @JsonProperty("message") final String message) {
        this.success = success;
        this.message = message;
    }

    public boolean getSuccess() {
        return success;
    }

    @NotNull
    public String getMessage() {
        return message;
    }

    @Override
    public String toString() {
        return "AddCheckResult{" +
                "success=" + success +
                ", message='" + message + '\'' +
                '}';
    }
}
