package ru.yandex.qe.dispenser.domain.juggler;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;


@ParametersAreNonnullByDefault
public class Check extends CheckData {
    @NotNull
    private final String host;
    @NotNull
    private final String service;

    @SuppressWarnings("ConstructorWithTooManyParameters")
    @JsonCreator
    public Check(@JsonProperty("host") final String host,
                 @JsonProperty("service") final String service,
                 @JsonProperty("namespace") final String namespace,
                 @JsonProperty("tags") final Collection<String> tags,
                 @JsonProperty("active") final ActiveCheckType active,
                 @JsonProperty("active_kwargs") final ActiveCheckKwargs kwargs,
                 @JsonProperty("notifications") final Collection<JugglerNotification> notifications,
                 @JsonProperty("description") final String description,
                 @Nullable @JsonProperty("meta") final Map<String, Object> meta) {
        super(namespace, tags, active, kwargs, notifications, description, meta);
        this.host = host;
        this.service = service;
    }

    @JsonCreator
    public Check(final String host, final String service, final CheckData checkData) {
        super(checkData.getNamespace(),
                checkData.getTags(),
                checkData.getActive(),
                checkData.getActiveKwargs(),
                checkData.getNotifications(),
                checkData.getDescription(),
                checkData.getMeta()
        );
        this.host = host;
        this.service = service;
    }

    @NotNull
    public String getHost() {
        return host;
    }

    @NotNull
    public String getService() {
        return service;
    }
}
