package ru.yandex.qe.dispenser.domain.juggler;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class CheckData {
    @NotNull
    protected final String namespace;
    @NotNull
    protected final Collection<String> tags;
    @NotNull
    protected final ActiveCheckType active;
    @NotNull
    protected final ActiveCheckKwargs activeKwargs;

    @NotNull
    protected final Collection<JugglerNotification> notifications;
    @NotNull
    protected final String description;

    @Nullable
    private final Map<String, Object> meta;

    @JsonCreator
    public CheckData(@JsonProperty("namespace") final String namespace,
                     @JsonProperty("tags") final Collection<String> tags,
                     @JsonProperty("active") final ActiveCheckType active,
                     @JsonProperty("active_kwargs") final ActiveCheckKwargs kwargs,
                     @JsonProperty("notifications") final Collection<JugglerNotification> notifications,
                     @JsonProperty("description") final String description,
                     @Nullable @JsonProperty("meta") final Map<String, Object> meta) {
        this.namespace = namespace;
        this.tags = tags;
        this.active = active;
        this.activeKwargs = kwargs;
        this.notifications = notifications;
        this.description = description;
        this.meta = meta;
    }

    @NotNull
    public String getNamespace() {
        return namespace;
    }

    @NotNull
    public Collection<String> getTags() {
        return tags;
    }

    @NotNull
    public ActiveCheckType getActive() {
        return active;
    }

    @NotNull
    @JsonProperty("active_kwargs")
    public ActiveCheckKwargs getActiveKwargs() {
        return activeKwargs;
    }

    @NotNull
    public Collection<JugglerNotification> getNotifications() {
        return notifications;
    }

    @NotNull
    public String getDescription() {
        return description;
    }

    @Nullable
    public Map<String, Object> getMeta() {
        return meta;
    }
}
