package ru.yandex.qe.dispenser.domain.juggler;

import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path("/api")
@Consumes({"application/json"})
@Produces({"application/json"})
@ParametersAreNonnullByDefault
public interface JugglerApi {

    @POST
    @Path("/checks/add_or_update")
    AddCheckResult addOrUpdate(Check check, @QueryParam("do") int execFlag);

    @GET
    @Path("/checks/checks")
    Map<String, Map<String, CheckData>> getServiceChecks(@Nullable @QueryParam("host_name") String host,
                                                         @Nullable @QueryParam("service_name") String service,
                                                         @QueryParam("include_notifications") int includeNotifications,
                                                         @Nullable @QueryParam("tag_name") String tagName,
                                                         @QueryParam("do") int execFlag);

    @GET
    @Path("/checks/remove_check")
    void removeCheck(@Nullable @QueryParam("host_name") String host,
                     @Nullable @QueryParam("service_name") String serviceName,
                     @Nullable @QueryParam("tag_name") String tags,
                     @QueryParam("do") int execFlag);
}
